﻿var permissions = {
    addedGroup: false,
    deletedGroups: [],
    roleFeatures: null,
    //Give implicit actions for nodes in the same group or in the specified group
    actionsMapping: {
        'USE_CAPI_APPOINTMT_COLUMNS': ['MODIFY'], //CAPI: Interviewer Appointment Grid Cols -> Modify
        'USE_CAPI_MESSAGES': ['MODIFY'], //CAPI: Messaging Contacts -> Modify
        'USE_QUOTAS_PER_AGENT': ['MODIFY'], //CAPI: Interviewer Quotas -> Modify
        'CREATE': ['MODIFY'], //Create -> Modify
        'COPY': ['CREATE'],
        'USE_INTERVIEW_SIMULATOR': ['MODIFY'], //Simulation -> Modify
        'USE_FIELD_OPT': ['READ'], //Field Options -> Read
        'USE_FILEBROWSER': ['READ'], //File Manager -> Read
        'USE_QUOTA_DEF': ['READ'], //Quotas: Definition -> Read
        'DELETE': ['READ'], //Delete -> Read
        'MODIFY': ['READ'], //Modify -> Read
        'START_STOP': ['READ'], //Start / Stop -> Read
        'ADD_USERS_TO_PROJECT': ['MODIFY'],
        'CC_FINDREPL_BROWSER': ['DATA_BROWSE_MODIFY'], //Browse Find and Replace -> Browse Modify
        'USE_RESP_LOCALISATION': ['DATA_BROWSE_MODIFY'], //Browse Reset Location -> Browse Modify
        'USE_SAMPLE_DEACTIVATION': ['DATA_BROWSE_MODIFY'], //Browse Activate/Deactivate -> Browse Modify
        'CAN_USE_BROWSER_DELETEALL': ['DATA_BROWSE_MODIFY'], //Browse Delete Filtered -> Browse Modify
        'USE_CAPI_ASSIGN_SAMPLE': ['DATA_BROWSE_MODIFY'], //Browse Assign Filtered -> Browse Modify
        'CAN_USE_BROWSER_UNFLAGCOMPLETEDCASES': ['DATA_BROWSE_MODIFY'], //Browse Unflag Completed -> Browse Modify
        'DATA_BROWSE_MODIFY': ['USE_DATA_BROWSER'], //Browse Modify -> Browse Access
        'USE_DATAPROCESSING': ['USE_DATA_BROWSER'], //Browse Data Processing -> Browse Access
        'USE_DATA_BROWSER': ['READ'], //Browse Access -> Read
        'USE_MON_GOALS': ['MODIFY'], //Project Monitoring Goals -> Modify        
        'USE_ACCESSTO_CASE_RESTRICTION_DEFINITION': ['READ'], //Project: Cases Restriction Definition -> Read
        'USE_ACCESSTO_PROJECT_DATA_VIEW': ['READ'], //Project: Data View -> Read
        'USE_CB_RULES': ['READ'], //Call-Back: Rules -> Read
        'USE_CB_RULES_EX': ['READ'], //Call-Back: Extended Rules -> Read
        'USE_CB_SHIFTS': ['READ'], //Call-Back: Shift -> Read
        'USE_CB_SLOTS': ['READ'], //Call-Back: Time Slots -> Read
        'USE_CB_ASGMNT': ['READ'], //Call-Back: Assignment -> Read
        'USE_CB_CALENDAR': ['READ'], //Call-Back: Calendar -> Read
        'CAN_USE_APPEARANCE': ['READ'], //Modules: Appearance -> Read
        'USE_TASKS': ['READ'], // Project: Tasks -> Read
        'CREATE_CODE': ['MODIFY_CODE'], //Open End Add Code -> Open End Modify
        'DELETE_CODE': ['MODIFY_CODE'], //Open End Delete Code -> Open End Modify
        'CAN_USE_IMPORT_OEC': ['MODIFY_CODE'], //Open End Import -> Open End Modify
        'CAN_USE_FIND_AND_REPLACE': ['MODIFY_CODE'], //Open End Find and Replace -> Open End Modify
        'MODIFY_CODE': ['USE_DATA_CODIFICATION'], //Open End Modify -> Open End Access
        'CAN_USE_EXPORT_OEC': ['USE_DATA_CODIFICATION'], //Open End Export -> Open End Access
        'USE_DATA_CODIFICATION': ['READ'], //Open End Access -> Read
        'DELETE_PENDINGTRANSACTION': ['USE_TRANSACTIONMANAGER'], //Reject Change -> Questionnaire Changes
        'COMMIT_PENDINGTRANSACTION': ['USE_TRANSACTIONMANAGER'], //Apply Change -> Questionnaire Changes
        //FEATURES
        //'USE_VIC_AS_ADMIN': ['USE_VIC_AS_PUBLISHER'],
        //'USE_VIC_AS_ADMIN': { 'REPORT2_CALLINBOUND': ['READ'], 'REPORT2_CAPITRACKING': ['READ'], 'REPORT2_PAUSETIME': ['READ'], 'REPORT2_OPENEND': ['READ'], 'REPORT2_MONITORING': ['READ'], 'REPORT2_QUOTAS66': ['READ'], 'REPORT2_CROSSTAB': ['READ'], 'REPORT2_CALLRESULT': ['READ'], 'REPORT2QPRINT': ['READ'], 'REPORT2_CTNR': ['READ'], 'REPORT2': ['READ'] }, //"14,1;14,9;4,1;4,9;15,9;9,9"
        'CAN_USE_MONITORING': { 'PROJECT': ['$UNLOCK'] }, //Use Monitoring -> UNLOCK Project
        'CAN_USE_USM': { 'USERS_CTNR': ['CREATE', 'DELETE'], 'USER': ['CREATE', 'DELETE'] } //Use Security -> READ UserGroup
    },

    // TODO
    // REMOVE FILE MANAGER AND DNC IF PII IS NOT CHECKED
    // REMOVE USE SECURITY IF USER CHANGES SECURITY FOR GROUP OR USERS

    //Give implicit actions for unlock group of object when giving permissions to an object
    actionTypesMapping: {
        'MACHINE': ['MACHINE_CTNR'], //Workstations -> Group of Workstations
        'PHONE_TEMPLATE': ['PHONE_TEMPLATE_CTNR'], //Phone Template -> Access Phone Templates
        'PROJECT': ['PROJECT_CTNR'], //Projects -> Group of Projects
        'QUESTIONNAIRE': ['QUESTIONNAIRE_CTNR'], //Questionnaires -> Group of Questionnaires
        'STORE': ['STORE_CTNR'], //Webspaces -> Group of Webspaces     
        'USER': ['USERS_CTNR'] //Users -> Group of Users
    },

    getRoleFeatures: function () {
        var roleId = $("#RoleId").val();

        if (roleId) {
            a4.callServerMethod(a4.getAction("GetFeatures", "Users", "Settings"), { roleId: roleId, name: "CCW_FEATURES", value: "" }, function (result) {
                permissions.roleFeatures = result;
            });
        }
    },

    getFeatureByAction: function (action) {
        return _.find(permissions.roleFeatures, function (r) { return r.Action == action });
    },

    changePermissionValue: function (selector, row, checked, permissionClass) {
        if (!row.hasClass("parent-row")) {
            var value = parseInt(row.attr("data-value"));
            var panel = row.closest(".v-panelPermissions");

            if (selector.closest(".permission-row").hasClass("feature_specific")) {
                panel = $("#FeatureAllowed").closest(".v-panelPermissions");
            }

            panel.addClass("changed");

            var change = checked ? value : value * -1;
            var currentValue = parseInt($("." + permissionClass, panel).val());
            $("." + permissionClass, panel).val(currentValue + change);
        }
    },

    changePermission: function (selector, permissionClass) {
        var row = selector.closest(".v-permissionRow");
        var checked = selector.is(":checked");
        permissions.changePermissionValue(selector, row, checked, permissionClass);

        // Uncheck sibling if checked
        if (checked) {
            $(".v-permission:checked", row).not(selector).prop("checked", false).trigger("change");
        }

        var allow = (permissionClass == "allowed");
        var deny = (permissionClass == "denied");
        var selectorClass = allow ? ".v-allowPermission" : ".v-denyPermission";
        var table = row.closest(".v-panelPermissions");
        var parentTable = row.closest("tbody");

        if (row.hasClass("section_feature") && !checked && permissionClass == "allowed") {
            $(".v-allowPermission:checked", table).prop("checked", false).trigger("change");
        }

        // Check that the global access point for the section is there
        if (allow && checked) {
            var sectionAccess = $(".section_feature:first .v-allowPermission", table);

            if (sectionAccess.length > 0 && !sectionAccess.is(":checked")) {
                sectionAccess.prop("checked", true).trigger("change");
            }
        }

        if (checked && deny && row.attr("data-deny-linked")) {
            var denyLinked = row.attr("data-deny-linked").split(",");

            _.each(denyLinked, function (item) {
                var linkItem = $(".v-permissionRow[data-value=" + item + "] " + selectorClass, parentTable);
                if (linkItem.length > 0 && !linkItem.is(":checked")) {
                    linkItem.prop("checked", true);
                    permissions.changePermission(linkItem, "denied");
                }
            });
        }

        if (checked && allow && row.attr("data-linked")) {
            var linked = row.attr("data-linked").split(",");

            _.each(linked, function (item) {
                var linkItem = $(".v-permissionRow[data-value=" + item + "] " + selectorClass, parentTable);
                if (linkItem.length > 0 && !linkItem.is(":checked")) {
                    linkItem.prop("checked", true);
                    permissions.changePermission(linkItem, "allowed");
                }
            });
        }
        else if (!checked) {
            var val = row.attr("data-value");
            var items = $(".v-permissionRow[data-linked=" + val + "],.v-permissionRow:checked[data-linked*='" + val + ",'],.v-permissionRow:checked[data-linked*='," + val + "'] ", table);
            $(selectorClass + ":checked", items).prop("checked", false).trigger("change");
        }

        if (row.hasClass("parent-row")) {
            var childs = row.closest("tbody").next();
            var inversedItemsSelector = (checked) ? ":not(:checked)" : ":checked";
            $(selectorClass + inversedItemsSelector, childs).prop("checked", checked).trigger("change");
        }

        // if unchecking child verify parent is unchecked
        if (!checked && !row.hasClass("parent-row") && !selector.hasClass("v-noChangeToParent")) {
            var parent = row.closest("tbody").prev();
            var checkedItem = $(selectorClass + ":checked", parent);

            if (checkedItem.length > 0 && checkedItem.closest(".section_feature").length == 0) {    // Do not uncheck first level permissions with levels
                checkedItem.prop("checked", false);
            }
        }

        // If all child elements are checked then check parent
        if (!row.hasClass("parent-row") && $(selectorClass + ":not(:checked)", parentTable).length == 0
            && $(selectorClass + ":not(:checked)", parentTable.prev()).length > 0) {
            $(".parent-row " + selectorClass, parentTable.prev()).prop("checked", true);
        }
    },

    changePermissionStateValue: function (item, value, setUpdated) {
        var iconCls = "";

        switch (value) {
            case 2: iconCls = "fa-check-square"; break;
            case 1: iconCls = "fa-check-square fa-green"; break;
            case 0: iconCls = "fa-square-o"; break;
            case -1: iconCls = "fa-minus-square fa-red"; break;
            case -2: iconCls = "fa-minus-square"; break;
        }

        item.attr("data-value", value);
        item.removeClass("fa-check-square fa-minus-square fa-green fa-red").addClass(iconCls);

        if (setUpdated) {
            item.closest(".v-panelPermissions").addClass("changed");

            $(".h-savePermissions, .h-saveAndClosePermissions", ".role-permissions").attr("disabled", false).prop("disabled", false);
        }
    },

    changePermissionState: function (item, newValue, doPropagate) {
        var row = item.closest(".v-permissionRow");
        var treeView = $(".v-nodesContainer", this.context);
        var hasSubMenu = $("li.node.selected", treeView).parents("ul.sub-menu").length > 1;
        var val = parseInt(item.attr("data-value"), 10);
        var initial = parseInt(item.attr("data-initial"), 10);
        var actionType = row.attr("data-type");
        var actionName = row.attr("data-action");

        if (newValue == undefined) {
            switch (val) {
                case 2: newValue = -1; break;
                case 1: newValue = (initial == 1 || !hasSubMenu) ? 0 : -1; break;
                case 0: newValue = 1; break;
                case -1: newValue = (initial == -1 || initial == 0) ? 0 : 1; break;
                case -2: newValue = 1; break;
            }
        }

        permissions.changePermissionStateValue(item, newValue, true);

        if (doPropagate) {
            if (actionName == "$UNLOCK") {
                var children = row.closest("tbody").next();

                $(".v-permissionRow .v-permissionState", children).each(function () {
                    permissions.changePermissionState($(this), newValue, false);
                });
            }
            else if (newValue == 1) { // We should only propagate "Allow"
                var table = row.closest("table");
                var context = $("tbody[data-type='" + actionType + "']", table);

                if (actionName in permissions.actionsMapping) {
                    var action = permissions.actionsMapping[actionName];

                    if (_.isArray(action)) {
                        permissions.grantDependencies(context, action, newValue);
                    }
                    else {
                        _.each(action, function (value, key) {
                            permissions.grantDependencies($("tbody[data-type='" + key + "']", table), value, newValue);
                        });
                    }
                }

                //Grant $UNLOCK for the current actionType                
                $(".v-permissionRow[data-action='$UNLOCK']", context).each(function () {
                    permissions.changePermissionState($(".v-permissionState", $(this)), newValue, false);
                });
            }
        }

        //Grant $UNLOCK for the dependencies
        permissions.grantUnlockDependencies(table, actionType, newValue);
    },

    grantDependencies: function (container, actions, newValue) {
        _.each(actions, function (action) {
            var element = $(".v-permissionRow[data-action='" + action + "']", container);
            permissions.changePermissionState($(".v-permissionState", element), newValue, (action != "$UNLOCK"));
        });
    },

    grantUnlockDependencies: function (container, actionType, newValue) {
        if (actionType in permissions.actionTypesMapping && newValue == 1) {
            _.each(permissions.actionTypesMapping[actionType], function (type) {
                var element = $(".v-permissionRow.parent-row[data-type='" + type + "']", container);
                permissions.changePermissionState(element.find(".v-permissionState"), newValue, false);
            });
        }
    },

    completeGroupSelectionForItem: function (listItem, selectedPanel, panel) {
        $("li.node.selected").removeClass("selected");
        listItem.addClass("selected");
        selectedPanel.hide();
        panel.show();
    },

    bindEvents: function () {
        $(document).on("change", ".v-allowPermission", function (event) {
            permissions.changePermission($(this), "allowed");
        });

        $(document).on("change", ".v-denyPermission", function () {
            permissions.changePermission($(this), "denied");
        });

        $(document).on("click", ".v-delete", function (e) {
            var li = $(this).closest("li");
            var groupId = li.attr("data-groupId");

            if (!li.hasClass("new"))
                permissions.deletedGroups.push(groupId);

            $(".v-panelPermissions[data-panelGroup=" + groupId + "]").remove();
            li.remove();

            e.stopPropagation();
        });

        $(document).on("click", ".h-folders-tree:not(.h-permissions-nodes) li.node:not(.selected)", function () {
            var li = $(this);
            var groupId = li.attr("data-groupid");
            var panel = $(".v-panelPermissions[data-panelGroup=" + groupId + "]");
            var selectedPanel = $(".v-panelPermissions:visible");
            var objectType = $("#ObjectType").val();

            var treeView = a4.top().$(".v-nodesContainer");
            var selectedFolder = treeView.a4listview("getHighlightedNode");

            if (panel.length == 0) {
                a4.callServerMethod(a4.getAction("GetGroupItemPermissions", "Users", "Settings"), { objectType: objectType, groupId: groupId, folderId: selectedFolder.id }, function (result) {
                    var groupsPanel = $(".v-groupsPanel");
                    groupsPanel.after(result);
                    panel = $(".v-panelPermissions[data-panelGroup=" + groupId + "]:first");
                    permissions.completeGroupSelectionForItem(li, selectedPanel, panel);
                });
            }

            permissions.completeGroupSelectionForItem(li, selectedPanel, panel);
        });

        $(document).on("click", ".v-confirmItemsButton", function () {
            var groups = $(".h-folders-tree");
            var objectType = $("#ObjectType").val();

            if (!permissions.addedGroup && $(".v-panelPermissions.changed:visible").length == 0 && _.size(permissions.deletedGroups) == 0) {
                modalDialog.close();
            }
            else {
                var itemId = $("#Id").val();
                var permissionsData = [];

                _.each($("ul.sub-menu li.node", groups), function (item) {
                    var groupId = $(item).attr("data-groupId");
                    var panel = $(".v-panelPermissions[data-panelGroup=" + groupId + "]");

                    if (panel.length > 0) {
                        permissionsData.push({ GroupId: groupId, ObjectId: itemId, ObjectTypeId: 2, AllowedPermissions: $("#Allowed", panel).val(), DeniedPermissions: $("#Denied", panel).val() });
                    }
                });

                a4.callServerMethod(a4.getAction("UpdateItemPermissions", "Users", "Settings"), { objectType: objectType, permissions: permissionsData, itemId: itemId, deletedGroups: permissions.deletedGroups }, function (success) {
                    modalDialog.close();
                });
            }
        });

        $(document).on("click", ".v-permissionState", function () {
            var item = $(this);
            permissions.changePermissionState(item, undefined, true);
        });

        $(document).on("click", ".h-savePermissions", function () {
            var selectedNode = $(".v-nodesContainer", this.context).a4listview("getHighlightedNode");
            permissions.saveState(selectedNode);
        });

        $(document).on("click", ".h-saveAndClosePermissions", function () {
            var selectedNode = $(".v-nodesContainer", selectedNode).a4listview("getHighlightedNode");
            permissions.saveState(selectedNode, true);
        });
    },

    setAutocompletes: function () {
        $(".v-copyPermissions").a4autocomplete({
            ajaxAction: a4.getAction("GetUserGroups", "Users", "Settings"),
            valueProperty: "Id",
            labelProperty: "Name",
            select: function (event, data) {
                a4.callServerMethod(a4.getAction("LoadGroupPermissions", "Users", "Settings"), { groupId: data.item.Id }, function (result) {
                    $(".permission-editor-content").html(result);
                });
            }
        });

        $(".v-groupsAutocomplete").a4autocomplete({
            ajaxAction: a4.getAction("GetUserGroups", "Users", "Settings"),
            valueProperty: "Id",
            labelProperty: "Name",
            select: function (event, data) {
                if (data && data.item) {
                    var container = $(this).closest(".v-groupsPanel");
                    var groups = $(".h-folders-tree");

                    if ($("li.node[data-groupid='" + data.item.Id + "']", groups).length == 0) {
                        var item = $(".v-templateItem").html().replace("{0}", data.item.Id).replace("{1}", data.item.Name);
                        $(".sub-menu", container).append(item);
                        permissions.addedGroup = true;
                        $("li.node[data-groupid='" + data.item.Id + "']", groups).addClass("new").trigger("click");
                    }

                    $(event.target).val("");
                }
            }
        });
    },

    getNodeItemPermissions: function (panel, container, data) {
        if (panel.length != 0) {
            $(".permissionTable", container).hide();
            panel.show();
        }
        else {
            var roleId = $("#RoleId").val();
            var node = data.node;

            a4.callServerMethod(a4.getAction("GetNodePermissions", "Users", "Settings"), { roleId: roleId, name: node.TypeName, value: node.Id, label: node.Name, isRoot: node.Root }, function (result) {
                $(".permissionTable", container).hide();
                container.append(result);
                panel = $(".permissionTable:last");
                panel.attr("data-nodeId", data.nodeId).attr("data-folderId", data.id).show();

                permissions.removeObsoleteItems(panel, node)

                // Set features if any
                $(".feature-row[data-type='CCW_FEATURES']:visible, .feature-grouped-row[data-type='CCW_FEATURES']:visible", panel).each(function () {
                    var item = $(this);
                    var feature = permissions.getFeatureByAction(item.attr("data-action"));

                    if (feature) {
                        item.attr("data-value", feature.ActionTypeId);
                        item.attr("data-actionId", feature.ActionId);

                        permissions.changePermissionStateValue($(".v-permissionState", item), feature.Permission);

                        // Grouped features have a logical group parent that is the previous tbody sibling of their shared tbody parent.
                        // Set the permission of the parent feature to "Allow" if any of the grouped feature is allowed.
                        // This is needed since there is no real $UNLOCK permission for that logical parent.
                        if ((feature.Permission == 1) && (item.hasClass("feature-grouped-row"))) {
                            var groupParent = item.parent().prev();
                            var groupFeatureItem = groupParent.children("tr").first();
                            permissions.changePermissionStateValue($(".v-permissionState", groupFeatureItem), 1);
                        }
                    }
                });
            });
        }
    },

    removeObsoleteItems: function (panel, node) {
        // Exception Start/Stop not available for these items
        var hideStartStopItems = ["QUESTIONNAIRE_CTNR", "QUESTIONNAIRE", "PHONE_TEMPLATE", "USERS_CTNR"];
        var startStopRow = $(".v-permissionRow[data-action='START_STOP']:visible", panel);
        var dataType = startStopRow.attr("data-type");

        if (_.contains(hideStartStopItems, node.TypeName) || _.contains(hideStartStopItems, dataType)) {
            startStopRow.remove();
        }

        // Remove "Access Phone Templates"
        if (node.TypeName == "SETTINGS_CTNR" || node.TypeName == "PHONE_TEMPLATE_CTNR") {
            $("tbody[data-type='PHONE_TEMPLATE_CTNR']", panel).remove();
        }

        // Users hide Create / Delete, except on top level
        if (node.TypeName == "USERS_CTNR" && !node.Root) {
            $(".v-permissionRow[data-type='USERS_CTNR'][data-action='CREATE']", panel).remove();
        }

        // Hide obsolete feature in CC
        if (node.TypeName == "PROJECT" || node.TypeName == "PROJECT_CTNR") {
            $(".v-permissionRow[data-action='USE_FILTER']", panel).remove(); // Filter
            $(".v-permissionRow[data-action='USE_INTERVIEWER']", panel).remove(); // Interviewer
            $(".v-permissionRow[data-action='USE_REPORTING']", panel).remove(); // Use Project Reports
        }
    },

    saveState: function (selectedNode, closeDialog) {
        var container = $(".v-permissions-container");
        var promise;

        if ($(".permissionTable:visible", container).hasClass("changed")) {
            promise = permissions.saveNodePermissions(container, selectedNode.TypeName, selectedNode.Id)
        }

        $.when(promise).then(function () {
            $(".h-savePermissions, .h-saveAndClosePermissions", ".role-permissions").attr("disabled", true).prop("disabled", true);

            if (closeDialog)
                modalDialog.close();
        });
    },

    initializeTreeView: function () {
        var container = $(".v-permissions-container");
        var roleId = $("#RoleId").val();

        this.treeview = $(".v-nodesContainer", this.context).a4listview({
            ajaxAction: a4.getAction("GetRoleNodes", "Users", "Settings", { roleId: roleId }),
            onDemand: true,
            properties: { Key: ["TypeName", "Id"] },
            icons: null,
            beforeHighlightNode: function (event, data) {
                if ($(".permissionTable:visible", container).hasClass("changed")) {
                    modalDialog.showUnsavedChangesDialog(function () {
                        permissions.saveState(data.node);
                        data.deferred.resolve();
                    },
                    function () {
                        $(".h-savePermissions, .h-saveAndClosePermissions", ".role-permissions").attr("disabled", true).prop("disabled", true);
                        data.deferred.resolve();
                    },
                    function () {
                        data.deferred.reject();
                    });

                    return false;
                }
            },
            selectNode: function (event, data) {
                if (data.selected) {
                    var container = $(".v-permissions-container");
                    var panel = $(".permissionTable[data-nodeId='" + data.node.TypeName + "'][data-nodeId='" + data.node.Id + "']", container);

                    permissions.getNodeItemPermissions(panel, container, data);
                }
            }
        });
    },

    saveNodePermissions: function (container, typeName, value) {
        var roleId = $("#RoleId").val();
        var nodes = [];
        var table = $(".permissionTable:visible", container);
        var promise;

        _.each($(".v-permissionState", table), function (r) {
            var item = $(r);
            var row = item.closest(".v-permissionRow");
            var val = parseInt(item.attr("data-value"), 10);

            // Do not save implicit grant/deny
            if (-1 <= val && val <= 1) {
                var level = parseInt(row.attr("data-level"), 10);
                var parent = (level != 1) ? $(".v-permissionRow.parent-row[data-level='1']", table).attr("data-value") : row.attr("data-value");
                // Uncomment the block below to debug individual permission information
                /*var workDataValue = row.attr("data-value");
                var workDataAction = row.attr("data-action");
                var workDataActionType = row.attr("data-type");
                var workParentRow = $(".v-permissionRow.parent-row[data-level='1']", table);
                var workParentRowDataValue = workParentRow.attr("data-value");
                var workParentRowDataType= workParentRow.attr("data-type");*/
                nodes.push({ "ActionId": row.attr("data-actionId"), "Action": row.attr("data-action"), "ActionTypeId": row.attr("data-value"), "ActionType": row.attr("data-type"), "Permission": val, "ParentId": parent });
            }

            // Keep internal features list up to date
            _.each(_.filter(nodes, function (f) { return f.ActionType == "CCW_FEATURES" }), function (n) {
                var feature = permissions.getFeatureByAction(n.Action);

                if (feature) {
                    feature.Permission = n.Permission;
                }
            });
        });

        if (nodes.length > 0) {
            promise = a4.callServerMethod(a4.getAction("UpdateNodePermissions", "Users", "Settings"), { roleId: roleId, name: typeName, value: value || 0, nodes: nodes }, function (result) {
                $(".permissionTable:visible", container).removeClass("changed");
            });
        }

        return promise;
    }
}

$(document).ready(function () {
    if ($(".v-permissionEditor").length > 0) {
        permissions.bindEvents();
        permissions.getRoleFeatures();
        permissions.setAutocompletes();
        permissions.initializeTreeView();
    }
});